//EX 8 Program Title:Determine PIV, Vdc,Idc,Vrms,Pdc and Irms for center tapped transformer full Wave Rectifier. /
///environment: Scilab 5.5.2
//Tested on OS: Windows 7 Professional, 64 bit
//Book: Electronics Devices and Circuit Theory  by Robert Boylestead and Nashelsky
/////////////////////////////////////////
clc;
clear all;
close;

//////////////////////////////////////////////////////////////////
disp('For Center Tapped Full Wave Rectifier Analysis:' );
RL=input('Enter the value of Load Resistance in Ohms       RL:');//Note:Press enter
Vac=input('Enter the value of Input AC Voltage in Volts     Vac:');//Note:Press enter
N1=input('Enter the Number of primary turns                 N1:');//Note:Press enter/
N2=input('Enter the Number of Secondary turns               N2:');//Note:Press enter/
mprintf('\n. \*****************************************************************\');
//////////////////////////////////////////////////////////////////
disp('To Analyse Center Tapped Full wave rectifier given data in the circuit is:' );
mprintf(' Load Resistance              RL:%2d ohm',RL);
mprintf('\n Input AC voltage             V1:%2d V',Vac);
mprintf('\n Number of Secondary turns    N2:%1d ',N2);
mprintf('\n Number of Primary turns      N1:%1d ',N1);
//////////////////Voltage at Secondary//////////////////////////////////
mprintf('\n. \*************Solution*********************************************\');
V2=Vac*(N2/N1);//Volts RMS voltage at secondary
mprintf('\n 1)Voltage at Secondary is V2:%2d',V2);
/////////////////Maximum Value at Secondary //////////////////////////////
mprintf('\n. \*******************************************************************\');
Vrms=sqrt(2)*V2; //Volt maxi. secondary voltage
mprintf('\n 2)Maximum value of secondary voltage is Vrms:%2d ',Vrms);
mprintf('\n. \********************************************************************\');
Vm=Vrms/2; //Volt  maxi. voltage at half of secondary
mprintf('\n 3)Maximum voltage value of half-secondary Winding is Vm:%2d ',Vm);
mprintf('\n. \*********************************************************************\');
//////////////Load Current//////////////////////////////////
Im=Vm/RL;   // Amperes peak value of load current
mprintf('\n 4)Maxi.value of load Current is Im:%1f A',Im);
mprintf('\n. \*********************************************************************\');
Idc=(2*Vm)/(3.14*RL);    //Amperes Load current
//Idc=Idc*1e3;  //mili amperes//
mprintf('\n 5)Average value of Load current is Idc:%1f A',Idc);
mprintf('\n. \*********************************************************************\');
Vdc=Idc*RL;   //Volts  dc Voltage
mprintf('\n 6)Average Value of Output Voltage is Vdc:%1f V',Vdc);
mprintf('\n. \*********************************************************************\');
Pdc=(Idc^2)*RL;    // Watts Average Power
mprintf('\n 7)Average Value Of load Power is Pdc:%1f W',Pdc);
mprintf('\n. \*********************************************************************\');
PIV=2*Vm;   //Volts  
mprintf('\n 8)Peak Inverse Voltage is PIV:%1d V',PIV);
mprintf('\n. \*********************************************************************\');
Vr=Vdc*0.482;   //Volts  Ripple voltage
mprintf('\n 9)Ripple Voltage is Vr:%1f V',Vr);
mprintf('\n. \*********************************************************************\');
Irms=0.707*(Vm/RL);    //Amperes RMS Value of Current
Irms=Irms*1e3;  // Mili amperes
mprintf('\n 10)RMS Value of  current is Irms:%1f mA',Irms);
mprintf('\n. \*********************************************************************\');

//output//
// For Center Tapped Full Wave Rectifier Analysis:   
//Enter the value of Load Resistance in Ohms       RL:1000
//Enter the value of Input AC Voltage in Volts     Vac:220
//Enter the Number of primary turns                 N1:1000
//Enter the Number of Secondary turns               N2:100

//. ***************************************************************** 
// To Analyse Center Tapped Full wave rectifier given data in 
//       the circuit is:                                      
//Load Resistance              RL:1000 ohm
// Input AC voltage             V1:220 V
 //Number of Secondary turns    N2:100 
// Number of Primary turns      N1:1000 
//. *************Solution*********************************************
// 1)Voltage at Secondary is V2:22
//. *******************************************************************
//2)Maximum value of secondary voltage is Vrms:31 
//. ********************************************************************
// 3)Maximum voltage value of half-secondary Winding is Vm:15 
//. *********************************************************************
//4)Maxi.value of load Current is Im:0.015556 A
//. *********************************************************************
//5)Average value of Load current is Idc:0.009909 A
//. **********************************************************************
 //6)Average Value of Output Voltage is Vdc:9.908503 V
//. *********************************************************************
// 7)Average Value Of load Power is Pdc:0.098178 W
//. *********************************************************************
 //8)Peak Inverse Voltage is PIV:31 V
//. *********************************************************************
// 9)Ripple Voltage is Vr:4.775898 V
//. *********************************************************************
// 10)RMS Value of  current is Irms:10.998339 mA
//. ********************************************************************* 
